// -----------------------------------------------------
// PROGRAMA: StepperControl_NO_FEEDBACK_LENTO.ino
// FUNÇÃO: Controla o motor com velocidade reduzida (5 RPM) para estabilidade.
// -----------------------------------------------------

// Inclui a Biblioteca Stepper do Arduino
#include <Stepper.h>

// --- CONFIGURAÇÕES DO MOTOR ---
// CORREÇÃO: Valor real medido - 2050 passos para uma volta completa (360°)
const int stepsPerRevolution = 2050;
Stepper myStepper = Stepper(stepsPerRevolution, 8, 10, 9, 11);

long stepsToMove = 0;

void setup() {
  Serial.begin(9600);
  // VELOCIDADE REDUZIDA PARA ESTABILIDADE
  myStepper.setSpeed(5); 
  Serial.println("ARDUINO-PRONTO");
}

void loop() {
  if (Serial.available() > 0) {
    // CORREÇÃO CRÍTICA: Aguarda um pouco para garantir que todos os dados chegaram
    // Isso evita ler valores parciais
    delay(50);
    
    // CORREÇÃO: Lê uma linha completa usando readStringUntil
    // Isso garante que lemos apenas um comando por vez
    String inputString = Serial.readStringUntil('\n');
    inputString.trim(); // Remove espaços e caracteres de controle
    
    // Converte a string para número
    stepsToMove = inputString.toInt();
    
    // CORREÇÃO: Limpa qualquer dado residual no buffer
    // Isso previne que valores antigos sejam lidos no próximo ciclo
    while (Serial.available() > 0) {
      Serial.read();
    }
    
    // CORREÇÃO: Só move se o valor for válido e diferente de zero
    // Isso evita movimentos acidentais com valores residuais ou inválidos
    if (stepsToMove != 0) {
      // 2. Movimenta o motor
      myStepper.step(stepsToMove);
    } 
    
    // 3. SEMPRE envia PRONTO para que o Python avance
    Serial.println("PRONTO");
    
    // 4. Pequeno delay para garantir que PRONTO foi enviado completamente
    delay(10);
  }
}